#include "../include/typedefs.h"

// Example code from MISRA C:2012 begin
/* Non-compliant */
uint16_t f ( uint16_t *p )
{
  return *p;
}

/* Compliant */
uint16_t g ( const uint16_t *p );

/* Constraint violation */
void h ( const uint16_t *p )
{
 *p = 0;
}

#include <string.h>

/* Non-compliant */
char last_char_bad ( char *const s )
{
  return s[ strlen ( s ) - 1u ];
}

/* Compliant */
char last_char_good ( const char *const s );

/* Non-compliant */
uint16_t first_bad ( uint16_t a[ 5 ] )
{
  return a[ 0 ];
}

/* Compliant */
uint16_t first_good ( const uint16_t a[ 5 ] );
// Example code from MISRA C:2012 end
